﻿using System;
using System.ComponentModel;
using System.Configuration;
using System.Diagnostics;
using System.Web.Services;
using System.Web.Services.Description;
using System.Web.Services.Protocols;
using System.Xml.Serialization;

namespace MSIBPlusPack.ContentManagement.Publishing.Placeholders.MapPointService 
{    
    /// <remarks/>
    [DebuggerStepThrough()]
    [DesignerCategory("code")]
    [WebServiceBinding(Name="CommonServiceSoap", Namespace="http://s.mappoint.net/mappoint-30/")]
    [XmlInclude(typeof(MapPointConstants))]
    [XmlInclude(typeof(FindResult[]))]
    public class CommonServiceSoap : SoapHttpClientProtocol {
        
        public CustomerInfoHeader CustomerInfoHeaderValue;
        
        public UserInfoHeader UserInfoHeaderValue;
        
        /// <remarks/>
        public CommonServiceSoap() {
            string urlSetting = ConfigurationSettings.AppSettings["MPFindService"];
            if ((urlSetting != null)) {
				if (urlSetting.EndsWith(@"\") || urlSetting.EndsWith("/"))
					this.Url = string.Concat(urlSetting, "Common.asmx");
				else
					this.Url = string.Concat(urlSetting, "/Common.asmx");
            }
            else {
                this.Url = "http://findv3.staging.mappoint.net/Find-30/Common.asmx";
            }
        }
        
        /// <remarks/>
        [SoapHeader("UserInfoHeaderValue")]
        [SoapHeader("CustomerInfoHeaderValue")]
        [SoapDocumentMethod("http://s.mappoint.net/mappoint-30/GetVersionInfo", RequestNamespace="http://s.mappoint.net/mappoint-30/", ResponseNamespace="http://s.mappoint.net/mappoint-30/", Use=SoapBindingUse.Literal, ParameterStyle=SoapParameterStyle.Wrapped)]
        public VersionInfo[] GetVersionInfo() {
            object[] results = this.Invoke("GetVersionInfo", new object[0]);
            return ((VersionInfo[])(results[0]));
        }
        
        /// <remarks/>
        public IAsyncResult BeginGetVersionInfo(AsyncCallback callback, object asyncState) {
            return this.BeginInvoke("GetVersionInfo", new object[0], callback, asyncState);
        }
        
        /// <remarks/>
        public VersionInfo[] EndGetVersionInfo(IAsyncResult asyncResult) {
            object[] results = this.EndInvoke(asyncResult);
            return ((VersionInfo[])(results[0]));
        }
        
        /// <remarks/>
        [SoapHeader("UserInfoHeaderValue")]
        [SoapHeader("CustomerInfoHeaderValue")]
        [SoapDocumentMethod("http://s.mappoint.net/mappoint-30/GetCountryRegionInfo", RequestNamespace="http://s.mappoint.net/mappoint-30/", ResponseNamespace="http://s.mappoint.net/mappoint-30/", Use=SoapBindingUse.Literal, ParameterStyle=SoapParameterStyle.Wrapped)]
        public CountryRegionInfo[] GetCountryRegionInfo(int[] entityIDs) {
            object[] results = this.Invoke("GetCountryRegionInfo", new object[] {
                        entityIDs});
            return ((CountryRegionInfo[])(results[0]));
        }
        
        /// <remarks/>
        public IAsyncResult BeginGetCountryRegionInfo(int[] entityIDs, AsyncCallback callback, object asyncState) {
            return this.BeginInvoke("GetCountryRegionInfo", new object[] {
                        entityIDs}, callback, asyncState);
        }
        
        /// <remarks/>
        public CountryRegionInfo[] EndGetCountryRegionInfo(IAsyncResult asyncResult) {
            object[] results = this.EndInvoke(asyncResult);
            return ((CountryRegionInfo[])(results[0]));
        }
        
        /// <remarks/>
        [SoapHeader("UserInfoHeaderValue")]
        [SoapHeader("CustomerInfoHeaderValue")]
        [SoapDocumentMethod("http://s.mappoint.net/mappoint-30/GetEntityTypes", RequestNamespace="http://s.mappoint.net/mappoint-30/", ResponseNamespace="http://s.mappoint.net/mappoint-30/", Use=SoapBindingUse.Literal, ParameterStyle=SoapParameterStyle.Wrapped)]
        public EntityType[] GetEntityTypes(string dataSourceName) {
            object[] results = this.Invoke("GetEntityTypes", new object[] {
                        dataSourceName});
            return ((EntityType[])(results[0]));
        }
        
        /// <remarks/>
        public IAsyncResult BeginGetEntityTypes(string dataSourceName, AsyncCallback callback, object asyncState) {
            return this.BeginInvoke("GetEntityTypes", new object[] {
                        dataSourceName}, callback, asyncState);
        }
        
        /// <remarks/>
        public EntityType[] EndGetEntityTypes(IAsyncResult asyncResult) {
            object[] results = this.EndInvoke(asyncResult);
            return ((EntityType[])(results[0]));
        }
        
        /// <remarks/>
        [SoapHeader("UserInfoHeaderValue")]
        [SoapHeader("CustomerInfoHeaderValue")]
        [SoapDocumentMethod("http://s.mappoint.net/mappoint-30/GetDataSourceInfo", RequestNamespace="http://s.mappoint.net/mappoint-30/", ResponseNamespace="http://s.mappoint.net/mappoint-30/", Use=SoapBindingUse.Literal, ParameterStyle=SoapParameterStyle.Wrapped)]
        public DataSource[] GetDataSourceInfo(string[] dataSourceNames) {
            object[] results = this.Invoke("GetDataSourceInfo", new object[] {
                        dataSourceNames});
            return ((DataSource[])(results[0]));
        }
        
        /// <remarks/>
        public IAsyncResult BeginGetDataSourceInfo(string[] dataSourceNames, AsyncCallback callback, object asyncState) {
            return this.BeginInvoke("GetDataSourceInfo", new object[] {
                        dataSourceNames}, callback, asyncState);
        }
        
        /// <remarks/>
        public DataSource[] EndGetDataSourceInfo(IAsyncResult asyncResult) {
            object[] results = this.EndInvoke(asyncResult);
            return ((DataSource[])(results[0]));
        }
        
        /// <remarks/>
        [SoapHeader("UserInfoHeaderValue")]
        [SoapHeader("CustomerInfoHeaderValue")]
        [SoapDocumentMethod("http://s.mappoint.net/mappoint-30/GetGreatCircleDistances", RequestNamespace="http://s.mappoint.net/mappoint-30/", ResponseNamespace="http://s.mappoint.net/mappoint-30/", Use=SoapBindingUse.Literal, ParameterStyle=SoapParameterStyle.Wrapped)]
        public Double[] GetGreatCircleDistances(LatLong[] latLongs) {
            object[] results = this.Invoke("GetGreatCircleDistances", new object[] {
                        latLongs});
            return ((Double[])(results[0]));
        }
        
        /// <remarks/>
        public IAsyncResult BeginGetGreatCircleDistances(LatLong[] latLongs, AsyncCallback callback, object asyncState) {
            return this.BeginInvoke("GetGreatCircleDistances", new object[] {
                        latLongs}, callback, asyncState);
        }
        
        /// <remarks/>
        public Double[] EndGetGreatCircleDistances(IAsyncResult asyncResult) {
            object[] results = this.EndInvoke(asyncResult);
            return ((Double[])(results[0]));
        }
    }
    
    /// <remarks/>
    [DebuggerStepThrough()]
    [DesignerCategory("code")]
    [WebServiceBinding(Name="FindServiceSoap", Namespace="http://s.mappoint.net/mappoint-30/")]
    [XmlInclude(typeof(MapPointConstants))]
    [XmlInclude(typeof(FindResult[]))]
    public class FindServiceSoap : SoapHttpClientProtocol {
        
        public CustomerInfoFindHeader CustomerInfoFindHeaderValue;
        
        public UserInfoFindHeader UserInfoFindHeaderValue;
        
        /// <remarks/>
        public FindServiceSoap() {
            string urlSetting = ConfigurationSettings.AppSettings["MPFindService"];
            if ((urlSetting != null)) {
				if (urlSetting.EndsWith(@"\") || urlSetting.EndsWith("/"))
					this.Url = string.Concat(urlSetting, "FindService.asmx");
				else
					this.Url = string.Concat(urlSetting, "/FindService.asmx");
            }
            else {
                this.Url = "http://findv3.staging.mappoint.net/Find-30/FindService.asmx";
            }
        }
        
        /// <remarks/>
        [SoapHeader("CustomerInfoFindHeaderValue")]
        [SoapHeader("UserInfoFindHeaderValue")]
        [SoapDocumentMethod("http://s.mappoint.net/mappoint-30/Find", RequestNamespace="http://s.mappoint.net/mappoint-30/", ResponseNamespace="http://s.mappoint.net/mappoint-30/", Use=SoapBindingUse.Literal, ParameterStyle=SoapParameterStyle.Wrapped)]
        public FindResults Find(FindSpecification specification) {
            object[] results = this.Invoke("Find", new object[] {
                        specification});
            return ((FindResults)(results[0]));
        }
        
        /// <remarks/>
        public IAsyncResult BeginFind(FindSpecification specification, AsyncCallback callback, object asyncState) {
            return this.BeginInvoke("Find", new object[] {
                        specification}, callback, asyncState);
        }
        
        /// <remarks/>
        public FindResults EndFind(IAsyncResult asyncResult) {
            object[] results = this.EndInvoke(asyncResult);
            return ((FindResults)(results[0]));
        }
        
        /// <remarks/>
        [SoapHeader("CustomerInfoFindHeaderValue")]
        [SoapHeader("UserInfoFindHeaderValue")]
        [SoapDocumentMethod("http://s.mappoint.net/mappoint-30/FindAddress", RequestNamespace="http://s.mappoint.net/mappoint-30/", ResponseNamespace="http://s.mappoint.net/mappoint-30/", Use=SoapBindingUse.Literal, ParameterStyle=SoapParameterStyle.Wrapped)]
        public FindResults FindAddress(FindAddressSpecification specification) {
            object[] results = this.Invoke("FindAddress", new object[] {
                        specification});
            return ((FindResults)(results[0]));
        }
        
        /// <remarks/>
        public IAsyncResult BeginFindAddress(FindAddressSpecification specification, AsyncCallback callback, object asyncState) {
            return this.BeginInvoke("FindAddress", new object[] {
                        specification}, callback, asyncState);
        }
        
        /// <remarks/>
        public FindResults EndFindAddress(IAsyncResult asyncResult) {
            object[] results = this.EndInvoke(asyncResult);
            return ((FindResults)(results[0]));
        }
        
        /// <remarks/>
        [SoapHeader("CustomerInfoFindHeaderValue")]
        [SoapHeader("UserInfoFindHeaderValue")]
        [SoapDocumentMethod("http://s.mappoint.net/mappoint-30/ParseAddress", RequestNamespace="http://s.mappoint.net/mappoint-30/", ResponseNamespace="http://s.mappoint.net/mappoint-30/", Use=SoapBindingUse.Literal, ParameterStyle=SoapParameterStyle.Wrapped)]
        public Address ParseAddress(string inputAddress, string countryRegion) {
            object[] results = this.Invoke("ParseAddress", new object[] {
                        inputAddress,
                        countryRegion});
            return ((Address)(results[0]));
        }
        
        /// <remarks/>
        public IAsyncResult BeginParseAddress(string inputAddress, string countryRegion, AsyncCallback callback, object asyncState) {
            return this.BeginInvoke("ParseAddress", new object[] {
                        inputAddress,
                        countryRegion}, callback, asyncState);
        }
        
        /// <remarks/>
        public Address EndParseAddress(IAsyncResult asyncResult) {
            object[] results = this.EndInvoke(asyncResult);
            return ((Address)(results[0]));
        }
        
        /// <remarks/>
        [SoapHeader("CustomerInfoFindHeaderValue")]
        [SoapHeader("UserInfoFindHeaderValue")]
        [SoapDocumentMethod("http://s.mappoint.net/mappoint-30/GetLocationInfo", RequestNamespace="http://s.mappoint.net/mappoint-30/", ResponseNamespace="http://s.mappoint.net/mappoint-30/", Use=SoapBindingUse.Literal, ParameterStyle=SoapParameterStyle.Wrapped)]
        public Location[] GetLocationInfo(LatLong location, string dataSourceName, GetInfoOptions options) {
            object[] results = this.Invoke("GetLocationInfo", new object[] {
                        location,
                        dataSourceName,
                        options});
            return ((Location[])(results[0]));
        }
        
        /// <remarks/>
        public IAsyncResult BeginGetLocationInfo(LatLong location, string dataSourceName, GetInfoOptions options, AsyncCallback callback, object asyncState) {
            return this.BeginInvoke("GetLocationInfo", new object[] {
                        location,
                        dataSourceName,
                        options}, callback, asyncState);
        }
        
        /// <remarks/>
        public Location[] EndGetLocationInfo(IAsyncResult asyncResult) {
            object[] results = this.EndInvoke(asyncResult);
            return ((Location[])(results[0]));
        }
        
        /// <remarks/>
        [SoapHeader("CustomerInfoFindHeaderValue")]
        [SoapHeader("UserInfoFindHeaderValue")]
        [SoapDocumentMethod("http://s.mappoint.net/mappoint-30/FindNearby", RequestNamespace="http://s.mappoint.net/mappoint-30/", ResponseNamespace="http://s.mappoint.net/mappoint-30/", Use=SoapBindingUse.Literal, ParameterStyle=SoapParameterStyle.Wrapped)]
        public FindResults FindNearby(FindNearbySpecification specification) {
            object[] results = this.Invoke("FindNearby", new object[] {
                        specification});
            return ((FindResults)(results[0]));
        }
        
        /// <remarks/>
        public IAsyncResult BeginFindNearby(FindNearbySpecification specification, AsyncCallback callback, object asyncState) {
            return this.BeginInvoke("FindNearby", new object[] {
                        specification}, callback, asyncState);
        }
        
        /// <remarks/>
        public FindResults EndFindNearby(IAsyncResult asyncResult) {
            object[] results = this.EndInvoke(asyncResult);
            return ((FindResults)(results[0]));
        }
    }

    /// <remarks/>
    [DebuggerStepThrough()]
    [DesignerCategory("code")]
    [WebServiceBinding(Name="RouteServiceSoap", Namespace="http://s.mappoint.net/mappoint-30/")]
    [XmlInclude(typeof(MapPointConstants))]
    [XmlInclude(typeof(FindResult[]))]
    public class RouteServiceSoap : SoapHttpClientProtocol {
        
        public CustomerInfoRouteHeader CustomerInfoRouteHeaderValue;
        
        public UserInfoRouteHeader UserInfoRouteHeaderValue;
        
        /// <remarks/>
        public RouteServiceSoap() {
            string urlSetting = ConfigurationSettings.AppSettings["MPRouteService"];
            if ((urlSetting != null)) {
				if (urlSetting.EndsWith(@"\") || urlSetting.EndsWith("/"))
					this.Url = string.Concat(urlSetting, "RouteService.asmx");
				else
					this.Url = string.Concat(urlSetting, "/RouteService.asmx");
            }
            else {
                this.Url = "http://routev3.staging.mappoint.net/Route-30/RouteService.asmx";
            }
        }
        
        /// <remarks/>
        [SoapHeader("CustomerInfoRouteHeaderValue")]
        [SoapHeader("UserInfoRouteHeaderValue")]
        [SoapDocumentMethod("http://s.mappoint.net/mappoint-30/CalculateSimpleRoute", RequestNamespace="http://s.mappoint.net/mappoint-30/", ResponseNamespace="http://s.mappoint.net/mappoint-30/", Use=SoapBindingUse.Literal, ParameterStyle=SoapParameterStyle.Wrapped)]
        public Route CalculateSimpleRoute(LatLong[] latLongs, string dataSourceName, SegmentPreference preference) {
            object[] results = this.Invoke("CalculateSimpleRoute", new object[] {
                        latLongs,
                        dataSourceName,
                        preference});
            return ((Route)(results[0]));
        }
        
        /// <remarks/>
        public IAsyncResult BeginCalculateSimpleRoute(LatLong[] latLongs, string dataSourceName, SegmentPreference preference, AsyncCallback callback, object asyncState) {
            return this.BeginInvoke("CalculateSimpleRoute", new object[] {
                        latLongs,
                        dataSourceName,
                        preference}, callback, asyncState);
        }
        
        /// <remarks/>
        public Route EndCalculateSimpleRoute(IAsyncResult asyncResult) {
            object[] results = this.EndInvoke(asyncResult);
            return ((Route)(results[0]));
        }
        
        /// <remarks/>
        [SoapHeader("CustomerInfoRouteHeaderValue")]
        [SoapHeader("UserInfoRouteHeaderValue")]
        [SoapDocumentMethod("http://s.mappoint.net/mappoint-30/CalculateRoute", RequestNamespace="http://s.mappoint.net/mappoint-30/", ResponseNamespace="http://s.mappoint.net/mappoint-30/", Use=SoapBindingUse.Literal, ParameterStyle=SoapParameterStyle.Wrapped)]
        public Route CalculateRoute(RouteSpecification specification) {
            object[] results = this.Invoke("CalculateRoute", new object[] {
                        specification});
            return ((Route)(results[0]));
        }
        
        /// <remarks/>
        public IAsyncResult BeginCalculateRoute(RouteSpecification specification, AsyncCallback callback, object asyncState) {
            return this.BeginInvoke("CalculateRoute", new object[] {
                        specification}, callback, asyncState);
        }
        
        /// <remarks/>
        public Route EndCalculateRoute(IAsyncResult asyncResult) {
            object[] results = this.EndInvoke(asyncResult);
            return ((Route)(results[0]));
        }
    }

    /// <remarks/>
    [DebuggerStepThrough()]
    [DesignerCategory("code")]
    [WebServiceBinding(Name="RenderServiceSoap", Namespace="http://s.mappoint.net/mappoint-30/")]
    [XmlInclude(typeof(MapPointConstants))]
    [XmlInclude(typeof(FindResult[]))]
    public class RenderServiceSoap : SoapHttpClientProtocol {
        
        public CustomerInfoRenderHeader CustomerInfoRenderHeaderValue;
        
        public UserInfoRenderHeader UserInfoRenderHeaderValue;
        
        /// <remarks/>
        public RenderServiceSoap() {
            string urlSetting = ConfigurationSettings.AppSettings["MPRenderService"];
            if ((urlSetting != null)) {
				if (urlSetting.EndsWith(@"\") || urlSetting.EndsWith("/"))
					this.Url = string.Concat(urlSetting, "RenderService.asmx");
				else
					this.Url = string.Concat(urlSetting, "/RenderService.asmx");
            }
            else {
                this.Url = "http://renderv3.staging.mappoint.net/Render-30/RenderService.asmx";
            }
        }
        
        /// <remarks/>
        [SoapHeader("CustomerInfoRenderHeaderValue")]
        [SoapHeader("UserInfoRenderHeaderValue")]
        [SoapDocumentMethod("http://s.mappoint.net/mappoint-30/GetMap", RequestNamespace="http://s.mappoint.net/mappoint-30/", ResponseNamespace="http://s.mappoint.net/mappoint-30/", Use=SoapBindingUse.Literal, ParameterStyle=SoapParameterStyle.Wrapped)]
        public MapImage[] GetMap(MapSpecification specification) {
            object[] results = this.Invoke("GetMap", new object[] {
                        specification});
            return ((MapImage[])(results[0]));
        }
        
        /// <remarks/>
        public IAsyncResult BeginGetMap(MapSpecification specification, AsyncCallback callback, object asyncState) {
            return this.BeginInvoke("GetMap", new object[] {
                        specification}, callback, asyncState);
        }
        
        /// <remarks/>
        public MapImage[] EndGetMap(IAsyncResult asyncResult) {
            object[] results = this.EndInvoke(asyncResult);
            return ((MapImage[])(results[0]));
        }
        
        /// <remarks/>
        [SoapHeader("CustomerInfoRenderHeaderValue")]
        [SoapHeader("UserInfoRenderHeaderValue")]
        [SoapDocumentMethod("http://s.mappoint.net/mappoint-30/ConvertToPoint", RequestNamespace="http://s.mappoint.net/mappoint-30/", ResponseNamespace="http://s.mappoint.net/mappoint-30/", Use=SoapBindingUse.Literal, ParameterStyle=SoapParameterStyle.Wrapped)]
        public PixelCoord[] ConvertToPoint(LatLong[] latLong, MapView view, int width, int height) {
            object[] results = this.Invoke("ConvertToPoint", new object[] {
                        latLong,
                        view,
                        width,
                        height});
            return ((PixelCoord[])(results[0]));
        }
        
        /// <remarks/>
        public IAsyncResult BeginConvertToPoint(LatLong[] latLong, MapView view, int width, int height, AsyncCallback callback, object asyncState) {
            return this.BeginInvoke("ConvertToPoint", new object[] {
                        latLong,
                        view,
                        width,
                        height}, callback, asyncState);
        }
        
        /// <remarks/>
        public PixelCoord[] EndConvertToPoint(IAsyncResult asyncResult) {
            object[] results = this.EndInvoke(asyncResult);
            return ((PixelCoord[])(results[0]));
        }
        
        /// <remarks/>
        [SoapHeader("CustomerInfoRenderHeaderValue")]
        [SoapHeader("UserInfoRenderHeaderValue")]
        [SoapDocumentMethod("http://s.mappoint.net/mappoint-30/ConvertToLatLong", RequestNamespace="http://s.mappoint.net/mappoint-30/", ResponseNamespace="http://s.mappoint.net/mappoint-30/", Use=SoapBindingUse.Literal, ParameterStyle=SoapParameterStyle.Wrapped)]
        public LatLong[] ConvertToLatLong(PixelCoord[] pixels, MapView view, int width, int height) {
            object[] results = this.Invoke("ConvertToLatLong", new object[] {
                        pixels,
                        view,
                        width,
                        height});
            return ((LatLong[])(results[0]));
        }
        
        /// <remarks/>
        public IAsyncResult BeginConvertToLatLong(PixelCoord[] pixels, MapView view, int width, int height, AsyncCallback callback, object asyncState) {
            return this.BeginInvoke("ConvertToLatLong", new object[] {
                        pixels,
                        view,
                        width,
                        height}, callback, asyncState);
        }
        
        /// <remarks/>
        public LatLong[] EndConvertToLatLong(IAsyncResult asyncResult) {
            object[] results = this.EndInvoke(asyncResult);
            return ((LatLong[])(results[0]));
        }
        
        /// <remarks/>
        [SoapHeader("CustomerInfoRenderHeaderValue")]
        [SoapHeader("UserInfoRenderHeaderValue")]
        [SoapDocumentMethod("http://s.mappoint.net/mappoint-30/GetBestMapView", RequestNamespace="http://s.mappoint.net/mappoint-30/", ResponseNamespace="http://s.mappoint.net/mappoint-30/", Use=SoapBindingUse.Literal, ParameterStyle=SoapParameterStyle.Wrapped)]
        public MapViewRepresentations GetBestMapView(Location[] locations, string dataSourceName) {
            object[] results = this.Invoke("GetBestMapView", new object[] {
                        locations,
                        dataSourceName});
            return ((MapViewRepresentations)(results[0]));
        }
        
        /// <remarks/>
        public IAsyncResult BeginGetBestMapView(Location[] locations, string dataSourceName, AsyncCallback callback, object asyncState) {
            return this.BeginInvoke("GetBestMapView", new object[] {
                        locations,
                        dataSourceName}, callback, asyncState);
        }
        
        /// <remarks/>
        public MapViewRepresentations EndGetBestMapView(IAsyncResult asyncResult) {
            object[] results = this.EndInvoke(asyncResult);
            return ((MapViewRepresentations)(results[0]));
        }
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    [XmlRoot(Namespace="http://s.mappoint.net/mappoint-30/", IsNullable=false)]
    public class CustomerInfoRenderHeader : CustomerInfoHeader {
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    [XmlRoot(Namespace="http://s.mappoint.net/mappoint-30/", IsNullable=false)]
    public class UserInfoRouteHeader : UserInfoHeader {
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    [XmlRoot(Namespace="http://s.mappoint.net/mappoint-30/", IsNullable=false)]
    public class CustomerInfoRouteHeader : CustomerInfoHeader {
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    [XmlRoot(Namespace="http://s.mappoint.net/mappoint-30/", IsNullable=false)]
    public class UserInfoRenderHeader : UserInfoHeader {
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    [XmlInclude(typeof(UserInfoRenderHeader))]
    [XmlInclude(typeof(UserInfoRouteHeader))]
    [XmlInclude(typeof(UserInfoFindHeader))]
    [XmlRoot(Namespace="http://s.mappoint.net/mappoint-30/", IsNullable=false)]
    public class UserInfoHeader : SoapHeader {
        
        /// <remarks/>
        public CultureInfo Culture;
        
        /// <remarks/>
        public DistanceUnit DefaultDistanceUnit;
        
        /// <remarks/>
        public CountryRegionContext Context;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class CultureInfo {
        
        /// <remarks/>
        public string Name;
        
        /// <remarks/>
        public int Lcid;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class MimeData {
        
        /// <remarks/>
        [XmlElement(DataType="base64Binary")]
        public Byte[] Bits;
        
        /// <remarks/>
        public string ContentID;
        
        /// <remarks/>
        public string MimeType;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class PixelRectangle {
        
        /// <remarks/>
        public int Bottom;
        
        /// <remarks/>
        public int Left;
        
        /// <remarks/>
        public int Right;
        
        /// <remarks/>
        public int Top;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class HotArea {
        
        /// <remarks/>
        public PixelRectangle IconRectangle;
        
        /// <remarks/>
        public PixelRectangle LabelRectangle;
        
        /// <remarks/>
        public string PinID;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class MapImage {
        
        /// <remarks/>
        public HotArea[] HotAreas;
        
        /// <remarks/>
        public MimeData MimeData;
        
        /// <remarks/>
        public MapViewRepresentations View;
        
        /// <remarks/>
        public string Url;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class MapViewRepresentations {
        
        /// <remarks/>
        public ViewByScale ByScale;
        
        /// <remarks/>
        public ViewByHeightWidth ByHeightWidth;
        
        /// <remarks/>
        public ViewByBoundingRectangle ByBoundingRectangle;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class ViewByScale : MapView {
        
        /// <remarks/>
        [DefaultValue(0)]
        public Double MapScale = 0;
        
        /// <remarks/>
        public LatLong CenterPoint;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class LatLong {
        
        /// <remarks/>
        [DefaultValue(0)]
        public Double Latitude = 0;
        
        /// <remarks/>
        [DefaultValue(0)]
        public Double Longitude = 0;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    [XmlInclude(typeof(ViewByBoundingRectangle))]
    [XmlInclude(typeof(ViewByBoundingLocations))]
    [XmlInclude(typeof(ViewByHeightWidth))]
    [XmlInclude(typeof(ViewByScale))]
    public abstract class MapView {
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class ViewByBoundingRectangle : MapView {
        
        /// <remarks/>
        public LatLongRectangle BoundingRectangle;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class LatLongRectangle {
        
        /// <remarks/>
        public LatLong Southwest;
        
        /// <remarks/>
        public LatLong Northeast;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class ViewByBoundingLocations : MapView {
        
        /// <remarks/>
        public Location[] Locations;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class Location {
        
        /// <remarks/>
        public LatLong LatLong;
        
        /// <remarks/>
        public Entity Entity;
        
        /// <remarks/>
        public Address Address;
        
        /// <remarks/>
        public MapViewRepresentations BestMapView;
        
        /// <remarks/>
        public string DataSourceName;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class Entity {
        
        /// <remarks/>
        public int ID;
        
        /// <remarks/>
        public string Name;
        
        /// <remarks/>
        public string DisplayName;
        
        /// <remarks/>
        public string TypeName;
        
        /// <remarks/>
        [XmlArrayItem("Property")]
        public EntityPropertyValue[] Properties;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class EntityPropertyValue {
        
        /// <remarks/>
        public string Name;
        
        /// <remarks/>
        public object Value;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class Address {
        
        /// <remarks/>
        public string AddressLine;
        
        /// <remarks/>
        public string PrimaryCity;
        
        /// <remarks/>
        public string SecondaryCity;
        
        /// <remarks/>
        public string Subdivision;
        
        /// <remarks/>
        public string PostalCode;
        
        /// <remarks/>
        public string CountryRegion;
        
        /// <remarks/>
        public string FormattedAddress;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class ViewByHeightWidth : MapView {
        
        /// <remarks/>
        [DefaultValue(0)]
        public Double Height = 0;
        
        /// <remarks/>
        [DefaultValue(0)]
        public Double Width = 0;
        
        /// <remarks/>
        public LatLong CenterPoint;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class PixelCoord {
        
        /// <remarks/>
        public int X;
        
        /// <remarks/>
        public int Y;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class Pushpin {
        
        /// <remarks/>
        public string IconDataSource;
        
        /// <remarks/>
        public string IconName;
        
        /// <remarks/>
        public string Label;
        
        /// <remarks/>
        public LatLong LatLong;
        
        /// <remarks/>
        public string PinID;
        
        /// <remarks/>
        public PixelCoord Pixel;
        
        /// <remarks/>
        public bool ReturnsHotArea;
        
        /// <remarks/>
        public bool LabelNearbyRoads;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class ImageFormat {
        
        /// <remarks/>
        [DefaultValue("image/GIF")]
        public string MimeType = "image/GIF";
        
        /// <remarks/>
        [DefaultValue(240)]
        public int Height = 240;
        
        /// <remarks/>
        [DefaultValue(296)]
        public int Width = 296;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class MapOptions {
        
        /// <remarks/>
        public RouteHighlightColor RouteHighlightColor;
        
        /// <remarks/>
        public RouteHighlightColor ConstructionDelayHighlightColor;
        
        /// <remarks/>
        public RouteHighlightColor ConstructionClosureHighlightColor;
        
        /// <remarks/>
        [DefaultValue(MapFontSize.Smaller)]
        public MapFontSize FontSize = MapFontSize.Smaller;
        
        /// <remarks/>
        public ImageFormat Format;
        
        /// <remarks/>
        [DefaultValue(false)]
        public bool IsOverviewMap = false;
        
        /// <remarks/>
        [DefaultValue(MapReturnType.ReturnImage)]
        public MapReturnType ReturnType = MapReturnType.ReturnImage;
        
        /// <remarks/>
        public Double PanHorizontal;
        
        /// <remarks/>
        public Double PanVertical;
        
        /// <remarks/>
        public MapStyle Style;
        
        /// <remarks/>
        [DefaultValue(1)]
        public Double Zoom = 1;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public enum RouteHighlightColor {
        
        /// <remarks/>
        DefaultColor,
        
        /// <remarks/>
        Green,
        
        /// <remarks/>
        Yellow,
        
        /// <remarks/>
        Cyan,
        
        /// <remarks/>
        Red,
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public enum MapFontSize {
        
        /// <remarks/>
        Smallest,
        
        /// <remarks/>
        Smaller,
        
        /// <remarks/>
        Medium,
        
        /// <remarks/>
        Larger,
        
        /// <remarks/>
        Largest,
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public enum MapReturnType {
        
        /// <remarks/>
        ReturnImage,
        
        /// <remarks/>
        ReturnUrl,
        
        /// <remarks/>
        ReturnSecureUrl,
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public enum MapStyle {
        
        /// <remarks/>
        DefaultStyle,
        
        /// <remarks/>
        Locator,
        
        /// <remarks/>
        Terrain,
        
        /// <remarks/>
        Road,
        
        /// <remarks/>
        Political,
        
        /// <remarks/>
        Small,
        
        /// <remarks/>
        LocatorBW,
        
        /// <remarks/>
        TerrainBW,
        
        /// <remarks/>
        RoadBW,
        
        /// <remarks/>
        PoliticalBW,
        
        /// <remarks/>
        SmallBW,
        
        /// <remarks/>
        Comprehensive,
        
        /// <remarks/>
        PhysicalFeatures,
        
        /// <remarks/>
        Tectonic,
        
        /// <remarks/>
        EarthByDay,
        
        /// <remarks/>
        EarthByNight,
        
        /// <remarks/>
        Ecoregions,
        
        /// <remarks/>
        Climate,
        
        /// <remarks/>
        TemperatureJanuary,
        
        /// <remarks/>
        TemperatureJuly,
        
        /// <remarks/>
        PrecipitationJanuary,
        
        /// <remarks/>
        PrecipitationJuly,
        
        /// <remarks/>
        PrecipitationAnnual,
        
        /// <remarks/>
        Languages,
        
        /// <remarks/>
        Religions,
        
        /// <remarks/>
        PopulationDensity,
        
        /// <remarks/>
        Parks,
        
        /// <remarks/>
        TimeZones,
        
        /// <remarks/>
        Outline,
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class MapSpecification {
        
        /// <remarks/>
        public string DataSourceName;
        
        /// <remarks/>
        public int[] HighlightedEntityIDs;
        
        /// <remarks/>
        public MapOptions Options;
        
        /// <remarks/>
        public Pushpin[] Pushpins;
        
        /// <remarks/>
        public Route Route;
        
        /// <remarks/>
        public MapView[] Views;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class Route {
        
        /// <remarks/>
        public RouteSpecification Specification;
        
        /// <remarks/>
        public RouteItinerary Itinerary;
        
        /// <remarks/>
        public CalculatedRouteRepresentation CalculatedRepresentation;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class RouteSpecification {
        
        /// <remarks/>
        public SegmentSpecification[] Segments;
        
        /// <remarks/>
        public RouteResultMask ResultMask;
        
        /// <remarks/>
        public string DataSourceName;
        
        /// <remarks/>
        public DriverProfile DriverProfile;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class SegmentSpecification {
        
        /// <remarks/>
        public Waypoint Waypoint;
        
        /// <remarks/>
        public SegmentOptions Options;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class Waypoint {
        
        /// <remarks/>
        public Location Location;
        
        /// <remarks/>
        public SnapType Snap;
        
        /// <remarks/>
        public string Name;
        
        /// <remarks/>
        public Location CalculatedLocation;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public enum SnapType {
        
        /// <remarks/>
        Normal,
        
        /// <remarks/>
        City,
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class SegmentOptions {
        
        /// <remarks/>
        public SegmentPreference Preference;
        
        /// <remarks/>
        [DefaultValue(true)]
        public bool CalculateSegmentMapView = true;
        
        /// <remarks/>
        [DefaultValue(true)]
        public bool CalculateDirectionMapView = true;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public enum SegmentPreference {
        
        /// <remarks/>
        Quickest,
        
        /// <remarks/>
        Shortest,
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    [Flags()]
    public enum RouteResultMask {
        
        /// <remarks/>
        Itinerary = 1,
        
        /// <remarks/>
        CalculatedRouteRepresentation = 2,
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class DriverProfile {
        
        /// <remarks/>
        [DefaultValue(-1)]
        public int DayStartTime = -1;
        
        /// <remarks/>
        [DefaultValue(-1)]
        public int DayEndTime = -1;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class RouteItinerary {
        
        /// <remarks/>
        public Segment[] Segments;
        
        /// <remarks/>
        public long TripTime;
        
        /// <remarks/>
        public long DrivingTime;
        
        /// <remarks/>
        public Double Distance;
        
        /// <remarks/>
        public MapViewRepresentations View;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class Segment {
        
        /// <remarks/>
        public Waypoint Waypoint;
        
        /// <remarks/>
        public Direction[] Directions;
        
        /// <remarks/>
        public long TripTime;
        
        /// <remarks/>
        public long DrivingTime;
        
        /// <remarks/>
        public Double Distance;
        
        /// <remarks/>
        public MapViewRepresentations View;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class Direction {
        
        /// <remarks/>
        public LatLong LatLong;
        
        /// <remarks/>
        public DirectionType DirectionType;
        
        /// <remarks/>
        public DirectionAction Action;
        
        /// <remarks/>
        public Single BearingOutOfTurn;
        
        /// <remarks/>
        public Single BearingIntoTurn;
        
        /// <remarks/>
        public long Duration;
        
        /// <remarks/>
        public Double Distance;
        
        /// <remarks/>
        public string Towards;
        
        /// <remarks/>
        public string Instruction;
        
        /// <remarks/>
        public string FormattedInstruction;
        
        /// <remarks/>
        public int ID;
        
        /// <remarks/>
        public MapViewRepresentations View;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public enum DirectionType {
        
        /// <remarks/>
        Driving,
        
        /// <remarks/>
        Border,
        
        /// <remarks/>
        StartOfDay,
        
        /// <remarks/>
        EndOfDay,
        
        /// <remarks/>
        Warning,
        
        /// <remarks/>
        Waypoint,
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public enum DirectionAction {
        
        /// <remarks/>
        Other,
        
        /// <remarks/>
        Depart,
        
        /// <remarks/>
        Arrive,
        
        /// <remarks/>
        TurnLeft,
        
        /// <remarks/>
        TurnRight,
        
        /// <remarks/>
        BearLeft,
        
        /// <remarks/>
        BearRight,
        
        /// <remarks/>
        Merge,
        
        /// <remarks/>
        Continue,
        
        /// <remarks/>
        TurnBack,
        
        /// <remarks/>
        TakeRoundabout,
        
        /// <remarks/>
        ConstructionDelay,
        
        /// <remarks/>
        ConstructionStop,
        
        /// <remarks/>
        NameChange,
        
        /// <remarks/>
        LeftLeft,
        
        /// <remarks/>
        LeftRight,
        
        /// <remarks/>
        RightLeft,
        
        /// <remarks/>
        RightRight,
        
        /// <remarks/>
        TakeRamp,
        
        /// <remarks/>
        TakeRampLeft,
        
        /// <remarks/>
        TakeRampRight,
        
        /// <remarks/>
        KeepStraight,
        
        /// <remarks/>
        KeepLeft,
        
        /// <remarks/>
        KeepRight,
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class CalculatedRouteRepresentation {
        
        /// <remarks/>
        [XmlElement(DataType="base64Binary")]
        public Byte[] Bits;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class WhereClause {
        
        /// <remarks/>
        [XmlArrayItem("Property")]
        public EntityPropertyValue[] SearchProperties;
        
        /// <remarks/>
        public SearchOperatorFlag SearchOperator;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public enum SearchOperatorFlag {
        
        /// <remarks/>
        And,
        
        /// <remarks/>
        Or,
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class FindFilter {
        
        /// <remarks/>
        public string EntityTypeName;
        
        /// <remarks/>
        public string[] PropertyNames;
        
        /// <remarks/>
        public WhereClause WhereClause;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class FindNearbySpecification {
        
        /// <remarks/>
        public string DataSourceName;
        
        /// <remarks/>
        public LatLong LatLong;
        
        /// <remarks/>
        public Double Distance;
        
        /// <remarks/>
        public FindFilter Filter;
        
        /// <remarks/>
        public FindOptions Options;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class FindOptions {
        
        /// <remarks/>
        public FindRange Range;
        
        /// <remarks/>
        public int SearchContext;
        
        /// <remarks/>
        public FindResultMask ResultMask;
        
        /// <remarks/>
        [DefaultValue(0.85)]
        public Double ThresholdScore = 0.85;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class FindRange {
        
        /// <remarks/>
        [DefaultValue(0)]
        public int StartIndex = 0;
        
        /// <remarks/>
        [DefaultValue(25)]
        public int Count = 25;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    [Flags()]
    public enum FindResultMask {
        
        /// <remarks/>
        LatLongFlag = 1,
        
        /// <remarks/>
        EntityFlag = 2,
        
        /// <remarks/>
        AddressFlag = 4,
        
        /// <remarks/>
        BestMapViewFlag = 8,
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class GetInfoOptions {
        
        /// <remarks/>
        [DefaultValue(true)]
        public bool IncludeAddresses = true;
        
        /// <remarks/>
        [DefaultValue(true)]
        public bool IncludeAllEntityTypes = true;
        
        /// <remarks/>
        public string[] EntityTypesToReturn;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class FindAddressSpecification {
        
        /// <remarks/>
        public string DataSourceName;
        
        /// <remarks/>
        public Address InputAddress;
        
        /// <remarks/>
        public FindOptions Options;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class MapPointConstants {
        
        /// <remarks/>
        [DefaultValue(6378.2)]
        public Double EarthRadiusInKilometers = 6378.2;
        
        /// <remarks/>
        [DefaultValue(3.1415926535897931)]
        public Double Pi = 3.1415926535897931;
        
        /// <remarks/>
        [DefaultValue(0.017453292519943295)]
        public Double RadiansPerDegree = 0.017453292519943295;
        
        /// <remarks/>
        [DefaultValue(57.295779513082323)]
        public Double DegreesPerRadian = 57.295779513082323;
        
        /// <remarks/>
        [DefaultValue(0.621371192237334)]
        public Double MilesPerKilometer = 0.621371192237334;
        
        /// <remarks/>
        [DefaultValue(1.609344)]
        public Double KilometersPerMile = 1.609344;
        
        /// <remarks/>
        [DefaultValue(0.0003048)]
        public Double KilometersPerFoot = 0.0003048;
        
        /// <remarks/>
        [DefaultValue(3280.8398950131232)]
        public Double FeetPerKilometer = 3280.8398950131232;
        
        /// <remarks/>
        [DefaultValue(0.85)]
        public Double FindScoreThreshold = 0.85;
        
        /// <remarks/>
        [DefaultValue(96)]
        public int AssumedDpi = 96;
        
        /// <remarks/>
        [DefaultValue(3.280839895013123)]
        public Double FeetPerMeter = 3.280839895013123;
        
        /// <remarks/>
        [DefaultValue(0.3048)]
        public Double MetersPerFoot = 0.3048;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class FindResult {
        
        /// <remarks/>
        public Double Score;
        
        /// <remarks/>
        public Location FoundLocation;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class FindResults {
        
        /// <remarks/>
        public int NumberFound;
        
        /// <remarks/>
        public int StartIndex;
        
        /// <remarks/>
        public FindResult[] Results;
        
        /// <remarks/>
        public Double TopScore;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class FindSpecification {
        
        /// <remarks/>
        public string DataSourceName;
        
        /// <remarks/>
        public string InputPlace;
        
        /// <remarks/>
        public string[] EntityTypeNames;
        
        /// <remarks/>
        public FindOptions Options;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class DataSource {
        
        /// <remarks/>
        public string Name;
        
        /// <remarks/>
        public string Version;
        
        /// <remarks/>
        public string Description;
        
        /// <remarks/>
        public DataSourceCapability Capability;
        
        /// <remarks/>
        public int[] EntityExtent;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    [Flags()]
    public enum DataSourceCapability {
        
        /// <remarks/>
        CanDrawMaps = 1,
        
        /// <remarks/>
        CanFindPlaces = 2,
        
        /// <remarks/>
        CanFindNearby = 4,
        
        /// <remarks/>
        CanRoute = 8,
        
        /// <remarks/>
        CanFindAddress = 16,
        
        /// <remarks/>
        HasIcons = 32,
        
        /// <remarks/>
        DataServiceQuery = 64,
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class EntityProperty {
        
        /// <remarks/>
        public string Name;
        
        /// <remarks/>
        public string DisplayName;
        
        /// <remarks/>
        public string DataType;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class EntityType {
        
        /// <remarks/>
        public string Name;
        
        /// <remarks/>
        public string DisplayName;
        
        /// <remarks/>
        public string ParentName;
        
        /// <remarks/>
        public string Definition;
        
        /// <remarks/>
        [XmlArrayItem("Property")]
        public EntityProperty[] Properties;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class CountryRegionInfo {
        
        /// <remarks/>
        public int EntityID;
        
        /// <remarks/>
        public LatLong LatLong;
        
        /// <remarks/>
        public string Iso2;
        
        /// <remarks/>
        public string Iso3;
        
        /// <remarks/>
        public string FriendlyName;
        
        /// <remarks/>
        public string OfficialName;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class VersionInfo {
        
        /// <remarks/>
        public string Component;
        
        /// <remarks/>
        public string Version;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public class CountryRegionContext {
        
        /// <remarks/>
        [DefaultValue(0)]
        public int EntityID = 0;
        
        /// <remarks/>
        public string Iso2;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    public enum DistanceUnit {
        
        /// <remarks/>
        Kilometer,
        
        /// <remarks/>
        Mile,
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    [XmlInclude(typeof(CustomerInfoRenderHeader))]
    [XmlInclude(typeof(CustomerInfoRouteHeader))]
    [XmlInclude(typeof(CustomerInfoFindHeader))]
    [XmlRoot(Namespace="http://s.mappoint.net/mappoint-30/", IsNullable=false)]
    public class CustomerInfoHeader : SoapHeader {
        
        /// <remarks/>
        public short CustomLogEntry;
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    [XmlRoot(Namespace="http://s.mappoint.net/mappoint-30/", IsNullable=false)]
    public class UserInfoFindHeader : UserInfoHeader {
    }
    
    /// <remarks/>
    [XmlType(Namespace="http://s.mappoint.net/mappoint-30/")]
    [XmlRoot(Namespace="http://s.mappoint.net/mappoint-30/", IsNullable=false)]
    public class CustomerInfoFindHeader : CustomerInfoHeader {
    }
}
